#Reshape to long

rm(list = ls())
setwd("C:/Users/richi/OneDrive/Desktop/ICPSR")
library(readstata13)
library(tidyr)
library(tidyverse)

# Load data
d <- read.dta13("test.dta")

names(d) #check out your names

#Option 1
#use "pivot_longer"
#specify the columns of interest from "d", so 7 and 8
#provide them a name, here "ft" for the values, and "candidate" for names
d.long <- pivot_longer(d, cols=7:8, names_to = "candidate", values_to = "ft") 
#create a candidate code, 1 for Trump, 2 for Biden
d.long <- d.long %>% 
mutate(candidate_code = if_else(candidate == "trump_ft", 1, 2))


#Option 2
d1<- reshape(d, direction="long", 
        varying=list(c("trump_ft","biden_ft")), #list the variables of interest
        v.names=c("FT"), #provide a name for the values that will be created per id
        timevar="candidate", idvar="id") #create candidate code and specify we want by "id"
d1 <- d1[order(d1$id),] #order data by "id"



